<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=UTF-8');

include 'conexion.php';

$data = json_decode(file_get_contents("php://input"));

// Validación de datos, el ID es crucial
if (!isset($data->id) || !is_numeric($data->id)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'El ID del producto es inválido.']);
    exit();
}

// Validación de los otros campos
if (
    !isset($data->name) || empty(trim($data->name)) ||
    !isset($data->price) || !is_numeric($data->price) ||
    !isset($data->moneda_base) || !in_array($data->moneda_base, ['USD', 'BS']) ||
    !isset($data->category) || empty(trim($data->category))
) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Todos los campos son obligatorios.']);
    exit();
}

$id = (int)$data->id;
$name = trim($data->name);
$price = (float)$data->price;
$moneda_base = $data->moneda_base;
$precio_bs = isset($data->precio_bs) && is_numeric($data->precio_bs) ? (float)$data->precio_bs : null;
$category = trim($data->category);
$icon = isset($data->icon) ? trim($data->icon) : 'cube-outline';

try {
    $sql = "UPDATE productos SET nombre = ?, precio = ?, moneda_base = ?, precio_bs = ?, categoria = ?, icon = ? WHERE id = ?";
    $stmt = $conn->prepare($sql);
    
    if ($stmt === false) {
        throw new Exception("Error al preparar la consulta de actualización: " . $conn->error);
    }
    
    $stmt->bind_param("sdsdssi", $name, $price, $moneda_base, $precio_bs, $category, $icon, $id);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo json_encode(['success' => true, 'message' => 'Producto actualizado exitosamente.']);
        } else {
            // Esto puede ocurrir si se envían los mismos datos que ya existían
            echo json_encode(['success' => true, 'message' => 'No se realizaron cambios en el producto.']);
        }
    } else {
        throw new Exception("Error al actualizar el producto: " . $stmt->error);
    }
    $stmt->close();

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}

$conn->close();
?>