<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=UTF-8');

include 'conexion.php';

$data = json_decode(file_get_contents("php://input"));

if (!isset($data->userId) || !isset($data->token) || empty($data->token)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Datos incompletos.']);
    exit();
}

$userId = (int)$data->userId;
$token = $data->token;

try {
    // Lógica profesional: Insertar el nuevo token. Si ya existe, se actualiza el usuario_id asociado.
    // Esto maneja el caso en que un nuevo usuario inicie sesión en un dispositivo ya registrado.
    $sql = "INSERT INTO dispositivos (usuario_id, push_token) VALUES (?, ?) 
            ON DUPLICATE KEY UPDATE usuario_id = VALUES(usuario_id)";
            
    $stmt = $conn->prepare($sql);
    
    if ($stmt === false) {
        throw new Exception("Error al preparar la consulta: " . $conn->error);
    }

    $stmt->bind_param("is", $userId, $token);

    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Dispositivo registrado/actualizado exitosamente.']);
    } else {
        throw new Exception("Error al registrar el dispositivo: " . $stmt->error);
    }
    $stmt->close();

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error del servidor: ' . $e->getMessage()]);
}

$conn->close();
?>