<?php
// Activar la visualización de errores para una depuración clara.
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=UTF-8');

// Incluir los archivos necesarios
include 'conexion.php';
include 'notification_sender.php';

/**
 * Script de Prueba para el Sistema de Notificaciones Push.
 *
 * USO:
 * Acceda a este script desde su navegador con un parámetro 'userId'.
 * Ejemplo: https://apps.metaflixstore.com/c&o/api/test_notification.php?userId=1
 *
 * OBJETIVO:
 * Enviará una notificación de prueba a todos los dispositivos registrados
 * para el usuario con el ID especificado.
 */

// 1. Obtener el ID del usuario desde la URL.
$userId = isset($_GET['userId']) ? (int)$_GET['userId'] : 0;

if ($userId === 0) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Por favor, especifique un ID de usuario válido en la URL (ej: ?userId=1)']);
    exit();
}

try {
    // 2. Buscar todos los tokens asociados a ese ID de usuario.
    $stmt = $conn->prepare("SELECT push_token FROM dispositivos WHERE usuario_id = ?");
    $stmt->bind_param("i", $userId);
    $stmt->execute();
    $result = $stmt->get_result();

    $tokens = [];
    while($row = $result->fetch_assoc()) {
        $tokens[] = $row['push_token'];
    }
    $stmt->close();

    if (empty($tokens)) {
        http_response_code(404);
        echo json_encode(['success' => false, 'message' => 'No se encontraron dispositivos o tokens de notificación para el usuario ID: ' . $userId]);
        exit();
    }

    // 3. Definir el contenido de la notificación de prueba.
    $title = "Prueba del Sistema C&O";
    $body = "¡Felicidades! Si recibes esto, el sistema de notificaciones está funcionando correctamente.";

    // 4. Enviar la notificación usando nuestra función centralizada.
    sendPushNotification($tokens, $title, $body);

    // 5. Devolver una respuesta de éxito.
    echo json_encode([
        'success' => true,
        'message' => 'Notificación de prueba enviada exitosamente a ' . count($tokens) . ' dispositivo(s) para el usuario ID: ' . $userId
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error del servidor: ' . $e->getMessage()]);
}

$conn->close();
?>
