<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST"); // Se permite el método POST
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'conexion.php'; // Asegúrate que la ruta a tu conexión sea correcta

$method = $_SERVER['REQUEST_METHOD'];

if ($method == 'GET') {
    // --- LÓGICA PARA OBTENER NOTIFICACIONES (SIN CAMBIOS) ---
    $userId = isset($_GET['userId']) ? (int)$_GET['userId'] : 0;
    if ($userId <= 0) {
        http_response_code(400);
        echo json_encode(["success" => false, "message" => "ID de usuario no proporcionado o inválido."]);
        exit();
    }

    try {
        $stmt = $conn->prepare("SELECT id, titulo, mensaje, leido, DATE_FORMAT(fecha_creacion, '%d/%m/%Y a las %h:%i %p') as fecha FROM notificaciones WHERE id_usuario = ? ORDER BY fecha_creacion DESC LIMIT 50");
        $stmt->bind_param("i", $userId);
        $stmt->execute();
        $result = $stmt->get_result();
        $notificaciones = $result->fetch_all(MYSQLI_ASSOC);
        
        $updateStmt = $conn->prepare("UPDATE notificaciones SET leido = 1 WHERE id_usuario = ? AND leido = 0");
        $updateStmt->bind_param("i", $userId);
        $updateStmt->execute();

        http_response_code(200);
        echo json_encode(["success" => true, "notifications" => $notificaciones]);

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(["success" => false, "message" => "Error interno del servidor: " . $e->getMessage()]);
    }

} elseif ($method == 'POST') {
    // --- NUEVA LÓGICA PARA ELIMINAR NOTIFICACIONES ---
    $data = json_decode(file_get_contents("php://input"));

    $notificationId = isset($data->notificationId) ? (int)$data->notificationId : 0;
    $userId = isset($data->userId) ? (int)$data->userId : 0;

    if ($notificationId <= 0 || $userId <= 0) {
        http_response_code(400);
        echo json_encode(["success" => false, "message" => "Faltan datos para eliminar la notificación."]);
        exit();
    }

    try {
        // La consulta se asegura de que un usuario solo pueda borrar SUS PROPIAS notificaciones
        $stmt = $conn->prepare("DELETE FROM notificaciones WHERE id = ? AND id_usuario = ?");
        $stmt->bind_param("ii", $notificationId, $userId);
        
        if ($stmt->execute()) {
            if ($stmt->affected_rows > 0) {
                http_response_code(200);
                echo json_encode(["success" => true, "message" => "Notificación eliminada."]);
            } else {
                http_response_code(404);
                echo json_encode(["success" => false, "message" => "No se encontró la notificación o no tienes permiso para eliminarla."]);
            }
        } else {
            throw new Exception("Error al ejecutar la consulta de eliminación.");
        }

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(["success" => false, "message" => "Error interno del servidor: " . $e->getMessage()]);
    }

} else {
    http_response_code(405);
    echo json_encode(["success" => false, "message" => "Método no permitido."]);
}

$conn->close();
?>