<?php
// Función reutilizable para enviar notificaciones push a través de Expo.
function sendPushNotification($tokens, $title, $body) {
    $messages = [];
    foreach ($tokens as $token) {
        // Valida que el token sea un Expo Push Token.
        if (substr($token, 0, 18) !== 'ExponentPushToken[') {
            continue;
        }

        $messages[] = [
            'to' => $token,
            'sound' => 'default',
            'title' => $title,
            'body' => $body
        ];
    }

    if (empty($messages)) {
        return;
    }

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://exp.host/--/api/v2/push/send');
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: application/json',
        'Accept-encoding: gzip, deflate',
        'Content-Type: application/json',
    ]);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($messages));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    // Se ejecuta el envío. En una app en producción, se manejaría la respuesta.
    $response = curl_exec($ch);
    curl_close($ch);
}
?>