<?php
include 'conexion.php';

$data = json_decode(file_get_contents("php://input"));

if (!isset($data->email) || !isset($data->password)) {
    echo json_encode(["success" => false, "message" => "Datos incompletos."]);
    exit();
}

$email = $data->email;
$password = $data->password;

// Usar sentencias preparadas para seguridad
$stmt = $conn->prepare("SELECT id, nombre, email, tipo, password FROM usuarios WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();
    
    // Verificar la contraseña hasheada
    if (password_verify($password, $user['password'])) {
        // Contraseña correcta
        echo json_encode([
            "success" => true,
            "user" => [
                "id" => $user['id'],
                "name" => $user['nombre'],
                "email" => $user['email'],
                "type" => $user['tipo']
            ]
        ]);
    } else {
        // Contraseña incorrecta
        echo json_encode(["success" => false, "message" => "La contraseña es incorrecta."]);
    }
} else {
    // Usuario no encontrado
    echo json_encode(["success" => false, "message" => "El email no se encuentra registrado."]);
}

$stmt->close();
$conn->close();
?>