<?php
ini_set('display_errors', 1); error_reporting(E_ALL);
header('Content-Type: application/json; charset=UTF-8');
include 'conexion.php';

$ventaId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($ventaId === 0) { http_response_code(400); echo json_encode(['error' => 'ID de venta no válido.']); exit(); }

$response = ['items' => [], 'total' => 0, 'total_bs' => 0, 'paymentMethod' => '', 'user' => '', 'date' => ''];

try {
    $sqlVenta = "SELECT v.monto_total, v.monto_total_bs, v.metodo_pago, u.nombre as userName, v.fecha_venta FROM ventas v JOIN usuarios u ON v.usuario_id = u.id WHERE v.id = ?";
    $stmtVenta = $conn->prepare($sqlVenta);
    $stmtVenta->bind_param("i", $ventaId);
    $stmtVenta->execute();
    $resultVenta = $stmtVenta->get_result();
    if ($resultVenta->num_rows > 0) {
        $ventaData = $resultVenta->fetch_assoc();
        $response['total'] = (float)$ventaData['monto_total'];
        $response['total_bs'] = (float)$ventaData['monto_total_bs'];
        $response['paymentMethod'] = $ventaData['metodo_pago'];
        $response['user'] = $ventaData['userName'];
        $response['date'] = date('d/m/Y H:i', strtotime($ventaData['fecha_venta']));
    } else { throw new Exception("Venta no encontrada."); }
    $stmtVenta->close();

    $sqlDetalle = "SELECT p.nombre as name, dv.cantidad as quantity, dv.precio_unitario as price FROM detalle_ventas dv JOIN productos p ON dv.producto_id = p.id WHERE dv.venta_id = ?";
    $stmtDetalle = $conn->prepare($sqlDetalle);
    $stmtDetalle->bind_param("i", $ventaId);
    $stmtDetalle->execute();
    $resultDetalle = $stmtDetalle->get_result();
    if ($resultDetalle->num_rows > 0) { while($row = $resultDetalle->fetch_assoc()) { $row['quantity'] = (int)$row['quantity']; $row['price'] = (float)$row['price']; $response['items'][] = $row; } }
    $stmtDetalle->close();
} catch (Exception $e) {
    http_response_code(500);
    $response['error'] = 'Error del servidor: ' . $e->getMessage();
}
echo json_encode($response);
$conn->close();
?>