<?php
header('Content-Type: application/json; charset=UTF-8');
ini_set('display_errors', 1);
error_reporting(E_ALL);

// --- Credenciales para la base de datos de la TASA DE CAMBIO ---
$tasa_servername = "localhost";
$tasa_username = "metaflix";       // Mismas credenciales, como se indicó
$tasa_password = "Imguilleo.1";    // Mismas credenciales, como se indicó
$tasa_dbname = "metaflixcom_renacer"; // Nombre de la base de datos de tasas

// Crear conexión para la tasa
$tasa_conn = new mysqli($tasa_servername, $tasa_username, $tasa_password, $tasa_dbname);

// Verificar la conexión
if ($tasa_conn->connect_error) {
    http_response_code(503); // Service Unavailable
    // Mensaje de error profesional y seguro para el cliente
    echo json_encode(['success' => false, 'message' => 'El servicio de tasa de cambio no está disponible en este momento.']);
    // Registrar el error real en el servidor para el desarrollador
    error_log("Fallo en la conexión a la base de datos de tasas: " . $tasa_conn->connect_error);
    exit();
}
$tasa_conn->set_charset("utf8");

// --- Consulta a la tabla 'tasa_cambio' ---
// Obtiene la tasa más reciente disponible ordenando por fecha de forma descendente.
$sql = "SELECT tasa FROM tasa_cambio ORDER BY fecha DESC LIMIT 1";
$result = $tasa_conn->query($sql);

if ($result && $result->num_rows > 0) {
    $tasa = $result->fetch_assoc();
    echo json_encode(['success' => true, 'tasa' => (float)$tasa['tasa']]);
} else {
    // Si no hay ninguna tasa registrada en la tabla, es un estado crítico.
    http_response_code(404); // Not Found
    echo json_encode(['success' => false, 'message' => 'No se encontró una tasa de cambio válida. Contacte al administrador.']);
}

$tasa_conn->close();
?>