<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=UTF-8');

include 'conexion.php';

if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['error' => 'Error de conexión a la base de datos.']);
    exit();
}

// La consulta se actualiza para obtener todos los campos de precios y moneda.
$sql = "SELECT id, nombre as name, precio as price, moneda_base, precio_bs, icon, categoria as category FROM productos";

$result = $conn->query($sql);

$products = [];
if ($result) {
    while($row = $result->fetch_assoc()) {
        $row['id'] = (int)$row['id'];
        // El precio principal 'price' siempre se asume como USD para consistencia en el frontend
        $row['price'] = (float)$row['price'];
        if ($row['precio_bs'] !== null) {
            $row['precio_bs'] = (float)$row['precio_bs'];
        }
        $products[] = $row;
    }
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Error al ejecutar la consulta de productos.', 'sql_error' => $conn->error]);
    $conn->close();
    exit();
}

echo json_encode($products);

$conn->close();
?>