<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=UTF-8');

include 'conexion.php';

// Recibir datos del usuario
$userId = isset($_GET['userId']) ? (int)$_GET['userId'] : 0;
$userType = isset($_GET['userType']) ? $_GET['userType'] : '';
$year = isset($_GET['year']) ? (int)$_GET['year'] : date('Y');
$month = isset($_GET['month']) ? (int)$_GET['month'] : date('m');

if ($userId === 0 || empty($userType)) {
    http_response_code(400);
    echo json_encode(['error' => 'Falta informacin del usuario.']);
    exit();
}

$response = ['expenses' => [], 'categories' => []];

try {
    // --- Consulta actualizada para filtrar y obtener el nombre del usuario ---
    $sqlExpenses = "
        SELECT 
            g.id, g.categoria as category, g.monto as amount, g.monto_bs as amount_bs,
            g.descripcion as description, u.nombre as userName,
            DATE_FORMAT(g.fecha_gasto, '%Y-%m-%d') as date, 
            DATE_FORMAT(g.fecha_gasto, '%H:%i') as time
        FROM gastos g
        JOIN usuarios u ON g.usuario_id = u.id
        WHERE YEAR(g.fecha_gasto) = ? AND MONTH(g.fecha_gasto) = ?
    ";
    
    $params = [$year, $month];
    $types = "ii";

    if ($userType === 'empleado') {
        $sqlExpenses .= " AND g.usuario_id = ?";
        $params[] = $userId;
        $types .= "i";
    }

    $sqlExpenses .= " ORDER BY g.fecha_gasto DESC";
    
    $stmtExpenses = $conn->prepare($sqlExpenses);
    $stmtExpenses->bind_param($types, ...$params);
    $stmtExpenses->execute();
    $resultExpenses = $stmtExpenses->get_result();

    if ($resultExpenses) {
        while($row = $resultExpenses->fetch_assoc()) {
            $row['id'] = (int)$row['id'];
            $row['amount'] = (float)$row['amount'];
            $row['amount_bs'] = (float)($row['amount_bs'] ?? 0);
            $response['expenses'][] = $row;
        }
    }
    $stmtExpenses->close();

    $sqlCategories = "SELECT id, nombre as name, icon, color FROM categorias_gastos ORDER BY nombre ASC";
    $resultCategories = $conn->query($sqlCategories);
    if ($resultCategories) { while($catRow = $resultCategories->fetch_assoc()) { $response['categories'][] = $catRow; } }

} catch (Exception $e) {
    http_response_code(500);
    $response['error'] = 'Error interno del servidor: ' . $e->getMessage();
}

echo json_encode($response);
$conn->close();
?>