<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=UTF-8');

include 'conexion.php';

$data = json_decode(file_get_contents("php://input"));
$userId = isset($data->userId) ? (int)$data->userId : 0;
$userType = isset($data->userType) ? $data->userType : '';

if ($userId === 0 || empty($userType)) {
    http_response_code(400);
    echo json_encode(['error' => 'Falta información del usuario.']);
    exit();
}

// --- NUEVO: CONTAR NOTIFICACIONES NO LEÍDAS ---
$stmt_count = $conn->prepare("SELECT COUNT(*) as unread_count FROM notificaciones WHERE id_usuario = ? AND leido = 0");
$stmt_count->bind_param("i", $userId);
$stmt_count->execute();
$count_result = $stmt_count->get_result()->fetch_assoc();
$unread_count = $count_result ? (int)$count_result['unread_count'] : 0;
$stmt_count->close();
// --- FIN DEL CÓDIGO NUEVO ---

$dashboardData = [
    'dailySales' => 0.0, 'dailySalesBs' => 0.0,
    'monthlySales' => 0.0, 'monthlySalesBs' => 0.0,
    'dailyExpenses' => 0.0, 'dailyExpensesBs' => 0.0,
    'monthlyExpenses' => 0.0, 'monthlyExpensesBs' => 0.0,
    'todayTransactions' => 0,
    'topProducts' => [],
    'recentTransactions' => [],
    'unreadNotifications' => $unread_count, // <-- DATO AÑADIDO AL ARRAY DE RESPUESTA
];

try {
    $today = date("Y-m-d");
    $month_start = date('Y-m-01 00:00:00');
    $month_end = date('Y-m-t 23:59:59');

    // Resumen Diario (Global para la empresa)
    $result = $conn->query("SELECT SUM(monto_total) as total, SUM(monto_total_bs) as total_bs FROM ventas WHERE DATE(fecha_venta) = '$today'");
    if ($result && $row = $result->fetch_assoc()) { $dashboardData['dailySales'] = (float)($row['total'] ?? 0); $dashboardData['dailySalesBs'] = (float)($row['total_bs'] ?? 0); }
    
    $result = $conn->query("SELECT SUM(monto) as total, SUM(monto_bs) as total_bs FROM gastos WHERE DATE(fecha_gasto) = '$today'");
    if ($result && $row = $result->fetch_assoc()) { $dashboardData['dailyExpenses'] = (float)($row['total'] ?? 0); $dashboardData['dailyExpensesBs'] = (float)($row['total_bs'] ?? 0); }

    // --- Resumen Mensual con Filtro por Rol ---
    $monthlySalesQuery = "SELECT SUM(monto_total) as total, SUM(monto_total_bs) as total_bs FROM ventas WHERE fecha_venta BETWEEN ? AND ?";
    $monthlyExpensesQuery = "SELECT SUM(monto) as total, SUM(monto_bs) as total_bs FROM gastos WHERE fecha_gasto BETWEEN ? AND ?";
    
    $params = [$month_start, $month_end];
    $types = "ss";

    if ($userType === 'empleado') {
        $monthlySalesQuery .= " AND usuario_id = ?";
        $monthlyExpensesQuery .= " AND usuario_id = ?";
        $params[] = $userId;
        $types .= "i";
    }

    $stmtSalesMonth = $conn->prepare($monthlySalesQuery);
    $stmtSalesMonth->bind_param($types, ...$params);
    $stmtSalesMonth->execute();
    $salesMonthResult = $stmtSalesMonth->get_result()->fetch_assoc();
    $stmtSalesMonth->close();
    if ($salesMonthResult) { $dashboardData['monthlySales'] = (float)($salesMonthResult['total'] ?? 0); $dashboardData['monthlySalesBs'] = (float)($salesMonthResult['total_bs'] ?? 0); }

    $stmtExpensesMonth = $conn->prepare($monthlyExpensesQuery);
    $stmtExpensesMonth->bind_param($types, ...$params);
    $stmtExpensesMonth->execute();
    $expensesMonthResult = $stmtExpensesMonth->get_result()->fetch_assoc();
    $stmtExpensesMonth->close();
    if ($expensesMonthResult) { $dashboardData['monthlyExpenses'] = (float)($expensesMonthResult['total'] ?? 0); $dashboardData['monthlyExpensesBs'] = (float)($expensesMonthResult['total_bs'] ?? 0); }
    
    // El resto de las consultas no cambian
    $resultVentas = $conn->query("SELECT COUNT(id) as count FROM ventas WHERE DATE(fecha_venta) = '$today'");
    $ventasCount = ($resultVentas) ? (int)$resultVentas->fetch_assoc()['count'] : 0;
    $resultGastos = $conn->query("SELECT COUNT(id) as count FROM gastos WHERE DATE(fecha_gasto) = '$today'");
    $gastosCount = ($resultGastos) ? (int)$resultGastos->fetch_assoc()['count'] : 0;
    $dashboardData['todayTransactions'] = $ventasCount + $gastosCount;

    $sqlTopProducts = "SELECT p.nombre as name, p.icon, SUM(dv.cantidad * dv.precio_unitario) as sales FROM detalle_ventas dv JOIN productos p ON dv.producto_id = p.id JOIN ventas v ON dv.venta_id = v.id WHERE v.fecha_venta >= '$month_start' GROUP BY p.id ORDER BY sales DESC LIMIT 3;";
    $result = $conn->query($sqlTopProducts);
    if ($result && $result->num_rows > 0) { $products = []; while($row = $result->fetch_assoc()) { $row['sales'] = (float)$row['sales']; $products[] = $row; } $dashboardData['topProducts'] = $products; }

    $whereClause = ($userType === 'empleado') ? "WHERE t.usuario_id = " . $userId : "";
    $sqlRecent = "
        SELECT 
            t.id, t.type, t.amount, t.amount_bs, t.timestamp, u.nombre as userName,
            CASE WHEN t.type = 'sale' THEN (SELECT p.nombre FROM detalle_ventas dv JOIN productos p ON dv.producto_id = p.id WHERE dv.venta_id = t.id ORDER BY dv.id ASC LIMIT 1) ELSE t.detail END as first_item_detail,
            CASE WHEN t.type = 'sale' THEN (SELECT COUNT(id) FROM detalle_ventas WHERE venta_id = t.id) ELSE 1 END as item_count
        FROM (
            (SELECT id, 'sale' as type, monto_total as amount, monto_total_bs as amount_bs, '' as detail, fecha_venta as timestamp, usuario_id FROM ventas)
            UNION ALL
            (SELECT id, 'expense' as type, monto as amount, monto_bs as amount_bs, categoria as detail, fecha_gasto as timestamp, usuario_id FROM gastos)
        ) as t
        JOIN usuarios u ON t.usuario_id = u.id
        $whereClause
        ORDER BY t.timestamp DESC
        LIMIT 10;
    ";
    
    $result = $conn->query($sqlRecent);
    if ($result && $result->num_rows > 0) {
        $transactions = [];
        while($row = $result->fetch_assoc()) {
            $transactions[] = ['id' => $row['id'], 'type' => $row['type'], 'amount' => (float)$row['amount'], 'amount_bs' => (float)$row['amount_bs'], 'detail' => $row['first_item_detail'], 'item_count' => (int)$row['item_count'], 'userName' => $row['userName'], 'time' => date('H:i', strtotime($row['timestamp']))];
        }
        $dashboardData['recentTransactions'] = $transactions;
    }
    
} catch (Exception $e) {
    http_response_code(500);
    $dashboardData['error'] = 'Error interno del servidor: ' . $e->getMessage();
}

echo json_encode($dashboardData);
$conn->close();
?>