<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=UTF-8');

include 'conexion.php';

$data = json_decode(file_get_contents("php://input"));

if (!isset($data->productId) || !is_numeric($data->productId)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'ID de producto no proporcionado o inválido.']);
    exit();
}

$productId = (int)$data->productId;

try {
    // Primero, verificar si el producto existe en detalles de ventas para evitar errores de integridad
    $check_sql = "SELECT COUNT(*) as count FROM detalle_ventas WHERE producto_id = ?";
    $check_stmt = $conn->prepare($check_sql);
    $check_stmt->bind_param("i", $productId);
    $check_stmt->execute();
    $result = $check_stmt->get_result()->fetch_assoc();
    $check_stmt->close();

    if ($result['count'] > 0) {
        http_response_code(409); // Conflict
        echo json_encode(['success' => false, 'message' => 'No se puede eliminar. El producto tiene ventas asociadas. Considere desactivarlo en su lugar.']);
        exit();
    }

    // Si no hay ventas, proceder a eliminar
    $sql = "DELETE FROM productos WHERE id = ?";
    $stmt = $conn->prepare($sql);
    
    if ($stmt === false) {
        throw new Exception("Error al preparar la consulta de eliminación: " . $conn->error);
    }

    $stmt->bind_param("i", $productId);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo json_encode(['success' => true, 'message' => 'Producto eliminado exitosamente.']);
        } else {
            http_response_code(404); // Not Found
            echo json_encode(['success' => false, 'message' => 'No se encontró el producto para eliminar.']);
        }
    } else {
        throw new Exception("Error al eliminar el producto: " . $stmt->error);
    }
    $stmt->close();

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}

$conn->close();
?>