<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=UTF-8');

include 'conexion.php';

$data = json_decode(file_get_contents("php://input"));

if (!isset($data->expenseId)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'ID de gasto no proporcionado.']);
    exit();
}

$expenseId = $data->expenseId;

try {
    $sql = "DELETE FROM gastos WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $expenseId);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo json_encode(['success' => true, 'message' => 'Gasto eliminado exitosamente.']);
        } else {
            http_response_code(404);
            echo json_encode(['success' => false, 'message' => 'No se encontró el gasto para eliminar.']);
        }
    } else {
        throw new Exception("Error al eliminar el gasto: " . $stmt->error);
    }
    $stmt->close();
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}

$conn->close();
?>