<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=UTF-8');

include 'conexion.php';
include 'notification_sender.php';

$conn->begin_transaction();

try {
    // --- OBTENER TASA DE CAMBIO ---
    $tasa_response = file_get_contents('https://apps.metaflixstore.com/c&o/api/get_tasa.php');
    $tasa_data = json_decode($tasa_response, true);
    if (!$tasa_data || !isset($tasa_data['success']) || !$tasa_data['success'] || $tasa_data['tasa'] <= 0) {
        throw new Exception('El servicio de tasa de cambio no está disponible.', 503);
    }
    $tasaDelDia = $tasa_data['tasa'];

    // --- PROCESAR VENTA ---
    $data = json_decode(file_get_contents("php://input"));
    if (!isset($data->userId) || !isset($data->paymentMethod) || !isset($data->cart) || !is_array($data->cart)) {
        throw new Exception('Datos de venta incompletos o mal formados.', 400);
    }

    $userId = $data->userId;
    $paymentMethod = $data->paymentMethod;
    $cart = $data->cart;
    $totalVentaUSD = 0;

    // --- GUARDAR VENTA PRINCIPAL ---
    $sqlVenta = "INSERT INTO ventas (usuario_id, metodo_pago, monto_total, monto_total_bs, tasa_del_dia) VALUES (?, ?, ?, ?, ?)";
    $stmtVenta = $conn->prepare($sqlVenta);
    // Temporalmente insertamos con total 0, lo actualizaremos después
    $stmtVenta->bind_param("isdds", $userId, $paymentMethod, $totalVentaUSD, $totalVentaBS, $tasaDelDia);
    $totalVentaBS = 0; // Inicializar
    $stmtVenta->execute();
    $ventaId = $conn->insert_id;

    // --- GUARDAR ITEMS DE LA VENTA ---
    $sqlItem = "INSERT INTO detalle_ventas (venta_id, producto_id, cantidad, precio_unitario) VALUES (?, ?, ?, ?)";
    $stmtItem = $conn->prepare($sqlItem);
    $primerProductoNombre = '';

    foreach ($cart as $index => $item) {
        $totalVentaUSD += $item->priceInUSD * $item->quantity;
        if ($index === 0) {
            $primerProductoNombre = $item->name;
        }
        $stmtItem->bind_param("iiid", $ventaId, $item->id, $item->quantity, $item->priceInUSD);
        $stmtItem->execute();
    }

    // --- ACTUALIZAR TOTALES DE LA VENTA ---
    $totalVentaBS = $totalVentaUSD * $tasaDelDia;
    $sqlUpdateVenta = "UPDATE ventas SET monto_total = ?, monto_total_bs = ? WHERE id = ?";
    $stmtUpdateVenta = $conn->prepare($sqlUpdateVenta);
    $stmtUpdateVenta->bind_param("ddi", $totalVentaUSD, $totalVentaBS, $ventaId);
    $stmtUpdateVenta->execute();

    // --- LÓGICA DE NOTIFICACIÓN PUSH Y EN APP ---
    $stmtUser = $conn->prepare("SELECT nombre, tipo FROM usuarios WHERE id = ?");
    $stmtUser->bind_param("i", $userId);
    $stmtUser->execute();
    $userResult = $stmtUser->get_result()->fetch_assoc();

    if ($userResult && $userResult['tipo'] === 'empleado') {
        // 1. Enviar Notificación Push
        $resultTokens = $conn->query("SELECT d.push_token FROM dispositivos d JOIN usuarios u ON d.usuario_id = u.id WHERE u.tipo = 'jefe'");
        $jefeTokens = [];
        while($row = $resultTokens->fetch_assoc()) {
            $jefeTokens[] = $row['push_token'];
        }

        $title = "Nueva Venta Registrada";
        $body = "El empleado {$userResult['nombre']} registró una venta de $" . number_format($totalVentaUSD, 2);
        
        if (!empty($jefeTokens)) {
            sendPushNotification($jefeTokens, $title, $body);
        }
        
        // 2. Guardar en la Base de Datos para el Centro de Notificaciones
        $resultJefes = $conn->query("SELECT id FROM usuarios WHERE tipo = 'jefe'");
        $jefesIds = [];
        while($row = $resultJefes->fetch_assoc()) {
            $jefesIds[] = $row['id'];
        }

        if (!empty($jefesIds)) {
            $stmtNotif = $conn->prepare("INSERT INTO notificaciones (id_usuario, titulo, mensaje) VALUES (?, ?, ?)");
            foreach ($jefesIds as $jefe_id) {
                $stmtNotif->bind_param("iss", $jefe_id, $title, $body);
                $stmtNotif->execute();
            }
        }
    }

    $conn->commit();
    http_response_code(201);
    echo json_encode(['success' => true, 'message' => 'Venta registrada exitosamente.', 'id' => $ventaId]);

} catch (Exception $e) {
    $conn->rollback();
    $errorCode = $e->getCode() > 0 ? $e->getCode() : 500;
    http_response_code($errorCode);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}

$conn->close();
?>