<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=UTF-8');

include 'conexion.php';

$data = json_decode(file_get_contents("php://input"));

// Validación rigurosa de los datos de entrada
if (
    !isset($data->name) || empty(trim($data->name)) ||
    !isset($data->price) || !is_numeric($data->price) ||
    !isset($data->moneda_base) || !in_array($data->moneda_base, ['USD', 'BS']) ||
    !isset($data->category) || empty(trim($data->category))
) {
    http_response_code(400); // Bad Request
    echo json_encode(['success' => false, 'message' => 'Todos los campos requeridos son obligatorios y deben tener el formato correcto.']);
    exit();
}

$name = trim($data->name);
$price = (float)$data->price;
$moneda_base = $data->moneda_base;
// precio_bs es opcional, puede ser nulo
$precio_bs = isset($data->precio_bs) && is_numeric($data->precio_bs) ? (float)$data->precio_bs : null;
$category = trim($data->category);
// icon es opcional
$icon = isset($data->icon) ? trim($data->icon) : 'cube-outline';


try {
    $sql = "INSERT INTO productos (nombre, precio, moneda_base, precio_bs, categoria, icon) VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    
    if ($stmt === false) {
        throw new Exception("Error al preparar la consulta: " . $conn->error);
    }
    
    // El tipo de dato para decimal/float es 'd', para string es 's'
    $stmt->bind_param("sdsdss", $name, $price, $moneda_base, $precio_bs, $category, $icon);

    if ($stmt->execute()) {
        http_response_code(201); // Created
        echo json_encode(['success' => true, 'message' => 'Producto agregado exitosamente.', 'id' => $conn->insert_id]);
    } else {
        throw new Exception("Error al registrar el producto: " . $stmt->error);
    }
    $stmt->close();

} catch (Exception $e) {
    http_response_code(500); // Internal Server Error
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}

$conn->close();
?>