<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=UTF-8');

include 'conexion.php';
include 'notification_sender.php';

$conn->begin_transaction();

try {
    // --- OBTENER TASA DE CAMBIO ---
    $tasa_response = file_get_contents('https://apps.metaflixstore.com/c&o/api/get_tasa.php');
    $tasa_data = json_decode($tasa_response, true);
    if (!$tasa_data || !isset($tasa_data['success']) || !$tasa_data['success'] || $tasa_data['tasa'] <= 0) {
        throw new Exception('El servicio de tasa de cambio no está disponible.', 503);
    }
    $tasaDelDia = $tasa_data['tasa'];

    // --- PROCESAR GASTO ---
    $data = json_decode(file_get_contents("php://input"));
    if (!isset($data->userId) || !isset($data->category) || !isset($data->amount) || !isset($data->description) || !isset($data->moneda)) {
        throw new Exception('Datos de gasto incompletos.', 400);
    }

    $userId = $data->userId;
    $category = $data->category;
    $amount = (float)$data->amount;
    $moneda = $data->moneda;
    $description = $data->description;

    // --- LÓGICA DE CONVERSIÓN ---
    $amountUSD = ($moneda === 'USD') ? $amount : $amount / $tasaDelDia;
    $amountBS = ($moneda === 'BS') ? $amount : $amount * $tasaDelDia;

    // --- GUARDAR GASTO ---
    $sql = "INSERT INTO gastos (usuario_id, categoria, monto, monto_bs, tasa_del_dia, descripcion) VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("isddds", $userId, $category, $amountUSD, $amountBS, $tasaDelDia, $description);
    $stmt->execute();
    $newExpenseId = $conn->insert_id;

    // --- LÓGICA DE NOTIFICACIÓN PUSH Y EN APP ---
    $stmtUser = $conn->prepare("SELECT nombre, tipo FROM usuarios WHERE id = ?");
    $stmtUser->bind_param("i", $userId);
    $stmtUser->execute();
    $userResult = $stmtUser->get_result()->fetch_assoc();

    if ($userResult && $userResult['tipo'] === 'empleado') {
        // 1. Enviar Notificación Push
        $resultTokens = $conn->query("SELECT d.push_token FROM dispositivos d JOIN usuarios u ON d.usuario_id = u.id WHERE u.tipo = 'jefe'");
        $jefeTokens = [];
        while($row = $resultTokens->fetch_assoc()) {
            $jefeTokens[] = $row['push_token'];
        }
        
        $title = "Nuevo Gasto Registrado";
        $body = "El empleado {$userResult['nombre']} registró un gasto de $" . number_format($amountUSD, 2) . " por '{$description}'.";

        if (!empty($jefeTokens)) {
            sendPushNotification($jefeTokens, $title, $body);
        }

        // 2. Guardar en la Base de Datos para el Centro de Notificaciones
        $resultJefes = $conn->query("SELECT id FROM usuarios WHERE tipo = 'jefe'");
        $jefesIds = [];
        while($row = $resultJefes->fetch_assoc()) {
            $jefesIds[] = $row['id'];
        }
        
        if (!empty($jefesIds)) {
            $stmtNotif = $conn->prepare("INSERT INTO notificaciones (id_usuario, titulo, mensaje) VALUES (?, ?, ?)");
            foreach ($jefesIds as $jefe_id) {
                $stmtNotif->bind_param("iss", $jefe_id, $title, $body);
                $stmtNotif->execute();
            }
        }
    }

    $conn->commit();
    http_response_code(201);
    echo json_encode(['success' => true, 'message' => 'Gasto registrado exitosamente.', 'id' => $newExpenseId]);

} catch (Exception $e) {
    $conn->rollback();
    $errorCode = $e->getCode() > 0 ? $e->getCode() : 500;
    http_response_code($errorCode);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}

$conn->close();
?>